/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StopWatch;

/**
 * Allows for configuring a separate logger for the StopWatch than for
 * its client/measured class.
 * 
 * Created Oct 13, 2006 12:11:16 PM
 * @author DNS   BOHMEG
 */
public class StopWatchLogger extends StopWatch {
	protected final Log logger = LogFactory.getLog(getClass());
	private String id;
	
	public StopWatchLogger() {
		this(StringUtils.EMPTY);
	}
	
	public StopWatchLogger(String id) {
		super(id);
		this.id = id;
		this.setKeepTaskList(false);
	}
	
	public void start() {
		start(this.id);
	}

	public void stopAndLog() {
		stop();
		log();
	}	

	public void stopAndLog(String returnDataSummary) {
		stop();
		log(returnDataSummary);
	}	

	public void stopAndLog(String returnDataSummary, Log targetLogger) {
		stop();
		log(returnDataSummary, targetLogger);
	}	
	
	public void log() {
		log(null);
	}

	public void log(String returnDataSummary) {
		log(returnDataSummary, this.logger);
	}	
	
	public void log(String returnDataSummary, Log targetLogger) {
		if(targetLogger.isTraceEnabled()) {
			if(StringUtils.isNotBlank(returnDataSummary))
				targetLogger.trace(this.shortSummary() + " - " + returnDataSummary);
			else
				targetLogger.trace(this.shortSummary() + " -");
		}
	}	
	
	public void reset() {
		if(this.isRunning())
			stop();
	}
}
