/********************************************************************
 Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util;

// Java Classes
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;

/**
 * This class provides generic helper methods for all objects.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ObjectUtils extends org.apache.commons.lang.ObjectUtils
{
    /**
     * Determines an object's serialized size.  Note that this method should be used sparingly since it will allocate
     * the memory needed to determine the size which will then need to be garbage collected by the VM. Also, the
     * serialization process can slow down processing if used on large objects.
     *
     * @param object The object whose size will be returned.
     *
     * @return the size of the object and all of its serialized contents or -1 if an error was encountered.
     */
    public static int getObjectSize(Object object)
    {
        // Initialize the size to -1.
        int size = -1;

        if (object != null)
        {
            try
            {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                byte[] bytes = baos.toByteArray();
                oos.close();
                baos.close();
                size = bytes.length;
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }

        // Return the size
        return size;
    }
    
	public static boolean didObjectChange(Object before, Object after) {
		if(before == null && after == null)
			return false;
		else if(before == null && after != null)
			return true;
		else if(before != null && after == null)
			return true;
		else
			return !before.equals(after);
	}    
}
