package gov.va.med.fw.util;

import java.io.File;
import java.util.Comparator;

/**
 * Sorts the File objects by last modified dates. oldest file
 * will be first in the list.
 * @author DNS   kavuer
 *
 */
public class FileModifiedDateComparator implements Comparator {

    public int compare(Object file1, Object file2) {

        long lastModified1 = ( (File) file1).lastModified();
        long lastModified2 = ( (File) file2).lastModified();

        if( lastModified1 > lastModified2 ){
            return 1;
        }
        else if( lastModified1 < lastModified2 ){
            return -1;
        }
        else{
            return 0;
        }
    }

}
