/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.util;

import java.util.Comparator;

// Java classes
import java.util.Date;

// Library classes

// Framework classes

// ESR classes

/**
 * Compares 2 date objects.  This is used in conjunction with Collections.sort
 *
 * Project: Framework</br>
 * Created on: 3:57:26 PM </br>
 *
 * @author DNS   LEV
 */
public class DateComparator implements Comparator {

	/**
	 * A default constructor
	 */
	public DateComparator() {
		super();
	}

	/**
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare( Object arg1, Object arg2 ) {
		
		int equal = 0;
		
		if( arg1 instanceof Date && arg2 instanceof Date ) {
			Date date1 = (Date)arg1;
			Date date2 = (Date)arg2;
			
			// Compare the 2 episodes for the most recent
			equal = (date1.after( date2 ) ? 1 : -1);
		}
		return equal;
	}
}
