package gov.va.med.fw.util;

// Java classes

// Library classes
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

// Framework classes

// ESR classes

public abstract class AbstractContextAwareTestCase extends AbstractDependencyInjectionSpringContextTests {

	/**
	 * An instance of DEFAULT_TEST_CONTEXT
	 */
	private static final String DEFAULT_TEST_CONTEXT = "fw/test_components.xml"; 

	/**
	 * An instance of configLocations
	 */
	private String[] configLocations = new String[] { DEFAULT_TEST_CONTEXT };

	/**
	 * A default constructor
	 */
	protected AbstractContextAwareTestCase() {
		super();
	}

	/**
	 * A default constructor
	 * @param name
	 */
	protected AbstractContextAwareTestCase( String name ) {
		setName(name);
	}

	/**
	 * A default constructor
	 * @param configFiles
	 */
	protected AbstractContextAwareTestCase(String[] configFiles) {
		initConfigLocations(configFiles, null);
	}

	protected AbstractContextAwareTestCase(String name, String[] configFiles) {
		this(name);
		initConfigLocations(configFiles, null);
	}

	protected AbstractContextAwareTestCase(String[] configFiles, String[] parentConfigFiles) {
		initConfigLocations(configFiles, parentConfigFiles);
	}

	protected AbstractContextAwareTestCase(String name, String[] configFiles,
			String[] parentConfigFiles) {
		this(name);
		initConfigLocations(configFiles, parentConfigFiles);
	}

	
	protected String[] getConfigLocations() {
		return configLocations;
	}
	
	/**
	 * Useful for html reporting to see the entire stack trace
	 * 
	 * @param message
	 * @param e
	 */
	protected void fail(String message, Exception e) {
		e.fillInStackTrace(); // just to get the most information possible
		Throwable cause = e;
		StringBuffer trace = new StringBuffer();
		while (cause != null) {
			trace.append("******").append(cause.getMessage()).append(" ").append(
					cause);
			cause = cause.getCause();
		}
		fail(message + trace.toString());
	}
	/**
	 * Initializes a test case with the specific name, using a parent's
	 * configuration files
	 * 
	 * @param testName
	 * @param configFiles
	 */
	private void initConfigLocations(String[] configFiles,
			String parentConfigFiles[]) {

		/*
		 * RATIONALE: merging the two into one ApplicationContext was performed so
		 * that Common can depend on Messaging's overriding of dataSource and
		 * transactionManager. Splitting them into two ApplicationContext's (as is
		 * done for the runtime application) would have consequences that the
		 * Common test_components.xml would be needed in the test.classpath of
		 * running Messaging's tests.
		 */

		int parentConfigFilesLength = 0;
		int configFilesLength = 0;
		
		if (parentConfigFiles != null)
			parentConfigFilesLength = parentConfigFiles.length;
		
		if (configFiles != null)
			configFilesLength = configFiles.length;
		
		String[] completeSetOfConfigFiles = new String[parentConfigFilesLength + configFilesLength];

		int index = 0, i = 0;
		while (i < parentConfigFilesLength) {
			completeSetOfConfigFiles[index++] = parentConfigFiles[i++];
		}
		i = 0;
		while (i < configFilesLength) {
			completeSetOfConfigFiles[index++] = configFiles[i++];
		}

		configLocations = completeSetOfConfigFiles;
	}
}