/********************************************************************
 Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.valuelist;

/**
 * A runtime exception that is thrown when a ValueListAdapter encounters an error. Since the ValueListAdapter interface
 * doesn't provide the ability to throw a non-runtime Exception, this runtime exception has been created to fill
 * this void.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ValueListException extends RuntimeException
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6183296357185113857L;

	/**
     * An empty exception
     */
    public ValueListException()
    {
        super();
    }

    /**
     * An exception with a specific message
     *
     * @param msg An exception message
     */
    public ValueListException(String msg)
    {
        super(msg);
    }

    /**
     * An exception with a specific parent exception
     *
     * @param e A parent exception in a chain
     */
    public ValueListException(Throwable e)
    {
        super(e);
    }

    /**
     * An exception with a specific parent exception and a message
     *
     * @param e A parent exception in a chain
     * @param msg An exception message
     */
    public ValueListException(String msg, Throwable e)
    {
        super(msg, e);
    }
}