/*********************************************************************
 * Copyright  2005-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.valuelist;

// Java Classes
import java.io.Serializable;

/**
 * An interface that defines a valuelist result item which is selectable.
 * Both the result object and its selectable boolean are maintained.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public interface SelectableResult extends Serializable
{
    /**
     * Determines if this result is selected or not.
     * @return True if the result is selected or false if not.
     */
    public boolean isSelected();

    /**
     * Sets whether this result is selected or not.
     * @param selected the selected value.
     */
    public void setSelected(boolean selected);

    /**
     * Gets the result object.
     * @return The result.
     */
    public Object getResult();

    /**
     * Sets the result object.
     * @param result The result.
     */
    public void setResult(Object result);
}
