// Package
package gov.va.med.fw.ui.valuelist;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;

/**
 * A runtime exception that is thrown when a value list search can't be performed due to
 * unsuffient privilidges.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class MissingCapabilityValueListException extends ValueListException {
   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = -2105918768569016048L;

   private Lookup missingCapability;

   public MissingCapabilityValueListException(String message) {
      super(message);
   }

   public MissingCapabilityValueListException(Lookup missingCapability) {
      this.missingCapability = missingCapability;
   }

   public MissingCapabilityValueListException(String message, Lookup missingCapability) {
      super(message);
      this.missingCapability = missingCapability;
   }

   public MissingCapabilityValueListException(String message, Lookup missingCapability,
         Throwable t) {
      super(message, t);
      this.missingCapability = missingCapability;
   }

   /**
    * @return Returns the missingCapability.
    */
   public Lookup getMissingCapability() {
      return missingCapability;
   }

   /**
    * @param missingCapability
    *           The missingCapability to set.
    */
   public void setMissingCapability(Lookup missingCapability) {
      this.missingCapability = missingCapability;
   }

   public String getMessage() {
      String message = super.getMessage();
      if( StringUtils.isEmpty(message) ) {
         if( missingCapability != null ) {
            return "Required capability " + missingCapability.getCode() + " ("
                  + missingCapability.getDescription() + ") is needed "
                  + "to perform this operation.";
         }
         else {
            return "A required capability is needed to perform this operation.";
         }
      }
      return message;
   }
}
