/*****************************************************************************************
 * Copyright  2005-2006 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.fw.ui.valuelist;

/**
 * An interface that defines a valuelist result item which is selectable. Both the result
 * object and its selectable boolean are maintained. The selected attribute defaults to
 * false initially.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class DefaultSelectableResult implements SelectableResult {
   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 7314198689215381598L;

   private Object result = null;

   private boolean selected = false;

   /**
    * @see SelectableResult#isSelected
    */
   public boolean isSelected() {
      return selected;
   }

   /**
    * @see SelectableResult#setSelected
    */
   public void setSelected(boolean selected) {
      this.selected = selected;
   }

   /**
    * @see SelectableResult#getResult()
    */
   public Object getResult() {
      return result;
   }

   /**
    * @see SelectableResult#setResult(Object)
    */
   public void setResult(Object result) {
      this.result = result;
   }
}
