// Package 
package gov.va.med.fw.ui.taglib;

// Imports
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.Globals;
import org.apache.strutsel.taglib.utils.EvalHelper;

import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;

import gov.va.med.fw.util.StringUtils;


/**
 * This tag adds a span tag around the enclosed body with a style of the user's choice. By default,
 * a message resource of label.spanStyle (SPANSTYLE_LABEL_KEY) will be used.  The style is only added if the name/property
 * returns a boolean that is true.  Otherwise, nothing is done.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class SpanStyleTag extends TagSupport
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 7284176374400567504L;

   /** The message resource key to use for the span style by default. */
    public static final String SPANSTYLE_LABEL_KEY = "label.spanStyle";

    private String name = null;
    private String property = null;
    private String scope = null;
    private String styleClass;

    public SpanStyleTag()
    {
        super();
    }

    /**
     * Process the start tag.
     * @throws javax.servlet.jsp.JspException if a JSP exception has occurred
     */
    public int doStartTag() throws JspException
    {
        // Determine if we should output the style
        boolean outputStyle = getOutputStyle();
        if (outputStyle)
        {
            TagUtils utils = TagUtils.getInstance();
            String spanStyle = getStyleClass();
            if (StringUtils.isEmpty(spanStyle))
            {
                spanStyle = utils.message(pageContext, null, Globals.LOCALE_KEY, SPANSTYLE_LABEL_KEY, null);
            }
            StringBuffer buffer = new StringBuffer("<span class=\"");
            buffer.append(spanStyle);
            buffer.append("\">");
            utils.write(pageContext, buffer.toString());
        }
        return (EVAL_BODY_INCLUDE);
    }

    /**
     * Process the end tag.
     * @throws javax.servlet.jsp.JspException if a JSP exception has occurred
     */
    public int doEndTag() throws JspException
    {
        // Determine if we should output the style
        boolean outputStyle = getOutputStyle();
        if (outputStyle)
        {
            TagUtils utils = TagUtils.getInstance();
            utils.write(pageContext,"</span>");
        }
        return (EVAL_PAGE);
    }

    protected boolean getOutputStyle() throws JspException
    {
        // Get the boolean value to use by looking up the bean property
        TagUtils utils = TagUtils.getInstance();
        Object value = utils.lookup(pageContext, getName(), getProperty(), getScope());

        // Determine if we should output the style
        boolean outputStyle = false;
        if (value != null)
        {
            if (value instanceof Boolean)
            {
                outputStyle = ((Boolean)value).booleanValue();
            }
            else
            {
                outputStyle = (new Boolean(value.toString())).booleanValue();
            }
        }
        return outputStyle;
    }

    /**
     * Release all allocated resources.
     */
    public void release()
    {
        super.release();
        name = null;
        property = null;
        scope = null;
    }

    public String getScope()
    {
        return scope;
    }

    public void setScope(String scope)
    {
        this.scope = scope;
    }

    public String getProperty()
    {
        return property;
    }

    public void setProperty(String prop)
    {
        this.property = prop;
        if (StringUtils.isNotEmpty(prop))
        {
            try
            {
                String string = EvalHelper.evalString("property", prop, this, pageContext);
                if (StringUtils.isNotEmpty(string))
                {
                    this.property = string;
                }
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

    public String getStyleClass()
    {
        return styleClass;
    }

    public void setStyleClass(String style)
    {
        this.styleClass = style;
        if (StringUtils.isNotEmpty(style))
        {
            try
            {
                String string = EvalHelper.evalString("styleClass", style, this, pageContext);
                if (StringUtils.isNotEmpty(string))
                {
                    this.styleClass = string;
                }
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
        if (StringUtils.isNotEmpty(name))
        {
            try
            {
                String string = EvalHelper.evalString("name", name, this, pageContext);
                if (StringUtils.isNotEmpty(string))
                {
                    this.name = string;
                }
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }
}
