/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.taglib;

// Java Classes
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.TagUtils;

/** A JSP tag that formats an input string to a phone number in the following 
 * following format: ###-###-####
 *
 * @author  Vu Le
 * @version 2.0
 */
public class PhoneNumberTag extends TagSupport {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -833890738140511754L;

	private static final String NUMBER_SEPARATOR = "-";
   
   private String name = null;
   private String property = null;
   private String scope = null;
   
   public PhoneNumberTag() {
      super();
   }
   
   /**
    * Name of the bean that contains the data we will be rendering.
    */
   public String getName() {
      return name;
   }
   
   public void setName(String name) {
      this.name = name;
   }
   
   /**
    * Name of the property to be accessed on the specified bean.
    */
   public String getProperty() {
      return property;
   }
   
   public void setProperty(String property) {
      this.property = property;
   }
   
   /**
    * The scope to be searched to retrieve the specified bean.
    */
   public String getScope() {
      return scope;
   }
   
   public void setScope(String scope) {
      this.scope = scope;
   }
   
   /**
    * Process the start tag.
    * @exception JspException if a JSP exception has occurred
    */
   public int doStartTag() throws JspException {
      
      TagUtils util = TagUtils.getInstance();
      // Look up the requested property value
      Object value = util.lookup( pageContext, 
                                  getName(), 
                                  getProperty(), 
                                  getScope() );
      // Nothing to output
      if( value == null )
         return (SKIP_BODY);  
      
      // Print this property value to our output writer, suitably filtered
      String output = value.toString();
      try {
         if( output.length() == 10 ) {
            StringBuffer format = new StringBuffer();
            format.append( output.substring( 0, 3 ) )
                  .append( NUMBER_SEPARATOR )
                  .append( output.substring( 3, 6 ) )
                  .append( NUMBER_SEPARATOR )
                  .append( output.substring( 6 ) );
            output = format.toString();
         }
      }
      catch( Throwable t ) {
         // Failed to convert so use an original value instead
      }
      util.write( pageContext, output );
      
      // Continue processing this page
      return (SKIP_BODY);
   }
   
   
   /**
    * Release all allocated resources.
    */
   public void release() {
      
      super.release();
      name = null;
      property = null;
      scope = null;
   }
}
