/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.taglib;

// J2SE Classes
import java.util.Map;

// J2EE Classes
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;

// Struts Classes
import org.apache.struts.taglib.TagUtils;

/**
 * A JSP tag that retrieves a bean from a map and calls a toString method on a
 * bean to display its string representation
 * 
 * @author Vu Le
 * @version 2.0
 */
public class MapPropertyTag extends TagSupport {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7002100854047831851L;

	private String name = null;

   private String property = null;

   private String scope = null;

   /** Creates a new instance of MapPropertyTag. */
   public MapPropertyTag() {
      super();
   }

   /**
    * Gets the name of the bean that contains the data that will be rendered.
    * 
    * @return Bean name.
    */
   public String getName() {
      return (this.name);
   }

   /**
    * Sets the name of the bean that contains the data that will be rendered.
    * 
    * @param name
    */
   public void setName(String name) {
      this.name = name;
   }

   /**
    * Gets the name of the property to be accessed on the specified bean.
    * 
    * @return Bean property.
    */
   public String getProperty() {
      return (this.property);
   }

   /**
    * Sets the name of the property to be accessed on the specified bean.
    * 
    * @param property
    */
   public void setProperty(String property) {
      this.property = property;
   }

   /**
    * Gets the scope to be searched to retrieve the specified bean.
    * 
    * @return Bean scope.
    */
   public String getScope() {
      return (this.scope);
   }

   /**
    * Sets the scope to be searched to retrieve the specified bean.
    * 
    * @param scope
    */
   public void setScope(String scope) {
      this.scope = scope;
   }

   /**
    * Process the start tag.
    * 
    * @exception JspException if a JSP exception has occurred
    */
   public int doStartTag() throws JspException {
      Map bean = null;
      Object value = null;

      TagUtils util = TagUtils.getInstance();
      try {
         // Look up the requested bean
         bean = (Map)util.lookup(pageContext, getName(), getScope());
         value = bean.get(this.getProperty());

         // Nothing to output
         if (value == null)
            return (SKIP_BODY);
      }
      catch (Throwable t) {
         // Failed to successfully retrieve the value.
      }
      util.write(pageContext, value != null ? value.toString() : "");

      // Continue processing this page
      return (SKIP_BODY);
   }

   /**
    * Release all allocated resources.
    */
   public void release() {
      super.release();
      name = null;
      property = null;
      scope = null;
   }
}