/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.taglib;

// Java
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import java.util.Calendar;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.text.ParseException;

// Struts
import org.apache.struts.taglib.TagUtils;

/**
 * Custom tag to display a date in the specific format
 * 
 * @author Vu Le
 * @version 1.0
 */
public class DateTag extends BodyTagSupport {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1509579046727397836L;

	/**
    * The format of the date.
    */
   private String format = null;

   /**
    * The name of the bean containing the attribute.
    */
   private String name = null;

   /**
    * The name of the property which will return date string
    */
   private String property = null;

   public DateTag() {
      super();
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public String getProperty() {
      return this.property;
   }

   public void setProperty(String property) {
      this.property = property;
   }

   public String getFormat() {
      return this.format;
   }

   public void setFormat(String format) {
      this.format = format;
   }

   /**
    * Formats a date string
    * 
    * @exception JspException
    *               if a JSP exception has occurred
    */
   public int doStartTag() throws JspException {

      SimpleDateFormat formatter = new SimpleDateFormat(format);
      String dateString = null;
      Date date = null;

      TagUtils util = TagUtils.getInstance();
      //If a property is specified try to format a date with it
      if (name != null && property != null) {
         Object value = util.lookup( pageContext, name, property );
         if (value != null) {
            dateString = (String) value;

            //Try to convert it to a Date to ensure it's valid
            try {
               date = formatter.parse(dateString);
               dateString = formatter.format(date);
            }
            catch (ParseException pe) {
               return (EVAL_PAGE);
            }
         }
         else {
            //The bean property returned null so do nothing
            return (EVAL_PAGE);
         }
      }
      else {
         dateString = formatter.format( Calendar.getInstance().getTime() );
      }

      util.write(pageContext, dateString);

      // Continue processing this page
      return (EVAL_BODY_BUFFERED);

   }

   /**
    * Evaluate the remainder of the current page normally.
    * 
    * @exception JspException
    *               if a JSP exception occurs
    */
   public int doEndTag() throws JspException {
      return (EVAL_PAGE);
   }

   /**
    * Release all allocated resources.
    */
   public void release() {
      super.release();
      name = null;
      property = null;
      format = null;
   }
}