/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.struts;

//Java imports
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

//Commons/Struts imports
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.DelegatingActionProxy;

//Framework imports
import gov.va.med.fw.validation.ActionValidation;

/**
 * @author Muadhu Katikal
 * @author Muddaiah Ranga //Added validationAction() method.
 * @version 3.0
 */
public class ServiceDelegatingActionProxy extends DelegatingActionProxy
		implements ActionValidation {

	/**
	 * A default constructor
	 */
	public ServiceDelegatingActionProxy() {
		super();
	}

	/**
	 * Overrides this method to set a servlet to the delegated action
	 * 
	 * @see org.springframework.web.struts.DelegatingActionProxy#getDelegateAction(org.apache.struts.action.ActionMapping)
	 */
	protected Action getDelegateAction(ActionMapping mapping)
			throws BeansException {

		WebApplicationContext wac = getWebApplicationContext(getServlet(),
				mapping.getModuleConfig());
		String beanName = determineActionBeanName(mapping);
		Action action = (Action) wac.getBean(beanName, Action.class);
		action.setServlet(getServlet());
		return action;
	}

	/**
	 * Performs business validation. This method will be called after
	 * validateForm() method in the action form is called. This method will be
	 * called only when there are no custom validation errors. Also, this method
	 * is called if the validation is enabled in the action mapping. The
	 * subclasses of this class needs to override this method and perform rules
	 * based or other business related validation.
	 * 
	 * @param request
	 *            The servlet request we are processing
	 * @param response
	 *            The servlet response we are creating
	 * @param form
	 *            The ActionForm instance we are populating
	 * @param mapping
	 *            The ActionMapping we are using
	 * @return The business validation messages
	 * @exception Exception
	 *                if any error occurs
	 */
	public ActionMessages validateAction(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		Action delegateAction = getDelegateAction(mapping);
		if (delegateAction != null
				&& delegateAction instanceof ActionValidation) {
			return ((ActionValidation) delegateAction).validateAction(mapping,
					form, request, response);
		}
		return null;
	}

	public void failedValidationCallback(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) {
		Action delegateAction = getDelegateAction(mapping);
		if (delegateAction != null
				&& delegateAction instanceof ActionValidation) {
			((ActionValidation) delegateAction).failedValidationCallback(
					mapping, form, request, response);
		}
	}
}