package gov.va.med.fw.ui.struts;

import gov.va.med.fw.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts.action.ActionMapping;

/**
 * Custom ActionMapping.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ServiceBrokerActionMapping extends ActionMapping 
{
   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6011911810882241960L;
	// A properties map
   private List validateMethodList;
   
   /** Getter for property validateOnMethod.
    * 
    * @return value of property validateOnMethod.
    */
   public List getValidateOnMethodList() 
   {
      return validateMethodList;
   }
   
   /** Setter for property validateOnMethod.
    * 
    * @param value New value of property validateOnMethod.
    */
   public void setValidateOnMethod(String value) 
   {
   		if(StringUtils.isNotEmpty(value))
   		{
   			String methods[] = value.split(",");
   			if(methods != null && methods.length > 0)
   			{
   				validateMethodList = new ArrayList();
   				for(int i=0; i<methods.length; i++)
   				{
   					String method = methods[i].trim();
   					if(StringUtils.isNotEmpty(method))
   					{
   						validateMethodList.add(method);
   					}
   				}
   			}
   		}
      
   }
}