/*
 * Created on Jan 10, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.fw.ui.struts;

// Java classes
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;

import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.ui.UIConstants;

/**
 * @author Vu Le
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class SecurityAction extends ServiceBrokerAction {

   protected SecurityAction() {
      super();
   }
   
   protected void setSecurityContext( HttpServletRequest request, SecurityContext context ) {
      putSandboxEntry( request, UIConstants.SECURITY_CONTEXT, context );
   }

   protected SecurityContext getSecurityContext( HttpServletRequest request ) {
      return (SecurityContext)getSandboxEntry( request, UIConstants.SECURITY_CONTEXT );
   }
   
   /**
    * check whether all permissions are granted
    * @param permissions
    * @return
    */
   public boolean isAllPermissionsGranted(List permissions) {
       List currentPermissions = new ArrayList(permissions);
       List grantedPermissions = getGrantedPermissions();
       currentPermissions.removeAll(grantedPermissions);
       return currentPermissions.size() > 0 ? false : true;       
   }
   /**
    * check atleast one of the permission is granted
    * @param permissions
    * @return
    */
   public boolean isAnyPermissionGranted(List permissions) {
       List grantedPermissions = getGrantedPermissions();
       grantedPermissions.retainAll(permissions);
       return grantedPermissions.size() > 0 ? true : false;     
   }
   
   //convenient methods to check for perssions
   public boolean isPermissionGranted(String permission) {
       List list = new ArrayList();
       list.add(permission);
       return isAnyPermissionGranted(list);     
   }
   
   public boolean isAnyPermissionGranted(String[] permissions) {
       List list = new ArrayList(permissions.length);
       for (int i=0; i<permissions.length; i++) 
           list.add(permissions[i]);
       return isAnyPermissionGranted(list);     
   }   
   /**
    * check that all permissions are not granted
    * @param permissions
    * @return
    */
   public boolean isAllPermissionsNotGranted(List permissions) {
       List grantedPermissions = getGrantedPermissions();
       grantedPermissions.retainAll(permissions);
       return grantedPermissions.size() > 0 ? false : true;    
   }
   
   protected List getGrantedPermissions() {
       return getPermissionsfromAuthorities(getAllGrantedAuthorities());
   }
   
   /**
    * Returns the list of permissions (Capability Code)
    * @param authorities
    * @return
    */
   protected List getPermissionsfromAuthorities(List authorities) {
       List permissions = new ArrayList ();
       for (Iterator i=authorities.iterator(); i.hasNext();) {
           permissions.add(((GrantedAuthority)i.next()).getAuthority());
       }
       return permissions;
   }
   /**
    * Returns all granted authorities
    * @param request
    * @return
    */
   protected List getAllGrantedAuthorities() {
	   org.acegisecurity.context.SecurityContext context = (org.acegisecurity.context.SecurityContext)SecurityContextHolder.getContext();
       if(null == context)
           return Collections.EMPTY_LIST;
       Authentication currentUser = context.getAuthentication();
       if(null == currentUser)
           return Collections.EMPTY_LIST;
       if(null == currentUser.getAuthorities() || currentUser.getAuthorities().length < 1)
       {
           return Collections.EMPTY_LIST;
       } else
       {
           List granted = Arrays.asList(currentUser.getAuthorities());
           return granted;
       }
   }
   
   protected UserPrincipal getLoggedInUser() {
       SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
       return (securityContext != null) ? securityContext.getUserPrincipal() : null;
   }
}