/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.struts;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.xmlDefinition.I18nFactorySet;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.NoSuchDefinitionException;

/**
 * @author Madhu Katikala (@user)
 */
public class CustomTilesFactorySet extends I18nFactorySet {
    
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6222559064667653975L;
	public static final String TILES_COMPONENT_DEFINITION =
        "gov.va.med.fw.ui.struts.TILES_COMPONENT_DEFINITION";
    
    /**
     * Default constructor
     */
    public CustomTilesFactorySet() {
        super();
    }

    /**
     * Constructor.
     * Init the factory by reading appropriate configuration file.
     * Delegates to the super class
     * @param servletContext Servlet context.
     * @param properties Map containing all properties.
     * @throws FactoryNotFoundException Can't find factory configuration file.
     */
    public CustomTilesFactorySet(ServletContext servletContext, Map properties)
        throws DefinitionsFactoryException {        
        super(servletContext, properties);
    }
    /** from FactorySet */
    /**
     * This method is overridden from FactorySet to set the ComponentDefinition
     * attribute in the request scope if it is found
     * Gets the component definition from the super class (FactorySet)
     */
    public ComponentDefinition getDefinition(String name, ServletRequest request, ServletContext servletContext)
        throws NoSuchDefinitionException, DefinitionsFactoryException {
       /* if( factories == null )
            throw new FactoryNotFoundException( "No definitions factory defined" );
        
        Object key = getDefinitionsFactoryKey( name, request, servletContext);
        DefinitionsFactory factory = getFactory( key, request, servletContext);
        ComponentDefinition compDef = factory.getDefinition( name, request, servletContext );
        */
        ComponentDefinition compDef = super.getDefinition(name,request,servletContext);
       	request.setAttribute(TILES_COMPONENT_DEFINITION,compDef);
        return compDef;
    }
}