/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.struts;

//java imports
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

//struts imports
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.Controller;

//framework imports

public abstract class AbstractTilesController implements Controller {

    protected transient Log logger = LogFactory.getLog(getClass());

    /**
	 * Empty constructor 
	 */
	public AbstractTilesController() {
	}       
    
 	/* (non-Javadoc)
	 * @see org.apache.struts.tiles.Controller#execute(org.apache.struts.tiles.ComponentContext, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.ServletContext)
	 */
	public abstract void execute(ComponentContext componentContext, 
            HttpServletRequest httpServletRequest,
			HttpServletResponse httpServletResponse, 
            ServletContext servletContext) throws Exception;

	/* (non-Javadoc)
	 * @see org.apache.struts.tiles.Controller#perform(org.apache.struts.tiles.ComponentContext, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.ServletContext)
	 */
	public final void perform(ComponentContext arg0, HttpServletRequest arg1,
			HttpServletResponse arg2, ServletContext arg3)
			throws ServletException, IOException {
	}
}
