package gov.va.med.fw.ui.filter;

// Java imports
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.context.WebApplicationContext;


/**
 * This is the servlet filter to remove all suspicious strings from request parameters before returning them to the application.
 * 
 * @version 1.0
 */
public class WebSecurityFilter extends BaseFilter {
	
	protected String ssoErrorUrl;

	/**
	 * This is the overridden method. 
	 * See Servlet API javadoc for further details.
	 * 
	 * @param request
	 *           is the request object
	 * @param response
	 *           is the response object
	 * @param filterChain
	 *           is the filter chain object
	 * @throws ServletException
	 * @throws IOException
	 */
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain filterChain) throws ServletException, IOException {
		//filterChain.doFilter(new XSSRequestWrapper((HttpServletRequest) request, (HttpServletResponse) response, getSsoErrorUrl()), response);
		
		XSSRequestWrapper wrapper = null; 		
		if (request instanceof HttpServletRequest) {
			wrapper = new XSSRequestWrapper((HttpServletRequest) request, (HttpServletResponse) response, getSsoErrorUrl());
		}
		 
		if (wrapper != null) {
			filterChain.doFilter(wrapper, response);
		}
		else { 
			filterChain.doFilter(request, response); 
		}
		
	}

    public String getSsoErrorUrl() {
    	return ssoErrorUrl;
    }

    public void setSsoErrorUrl(String ssoErrorUrl) {
    	this.ssoErrorUrl = ssoErrorUrl;
    }	
}
