/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.filter;

// Java classes
import java.util.Map;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

// Framework classes
import gov.va.med.fw.ui.UIConstants;

/**
* This filter works in conjunction with a SecurityAction to check if 
* a user has successfully logged into an application by searchinf for
* a securityContext in a session 
*/
public class AccessControlFilter extends BaseFilter {
    
   private String redirectPage = null; 
   
   /**
    *  A default constructor for the filter.
    */
   public AccessControlFilter() {
      super();
   }

   /**
    * This method performs the specific task of handling input in a desired
    *  way. Each filter, after handling the input itself, will pass the input
    *  to the next filter in the chain for further input processing. All derived
    *  filters must provide a specific implementation of this method.
    *  @param request The input information contained in ServletRequest object.
    *  @param response The outgoing data container in ServletResponse object.
    *  @param chain    The filter chain containing all the filters for a
    *                  particular group of activities.
    *  @throws IOException When input retrieval encounters problem.
    *  @throws ServletException To indicate problems in servlet parameters
    *                              and its behavior.
    */
   public void doFilter( ServletRequest request,
                         ServletResponse response,
                         FilterChain chain)
   	throws IOException, ServletException {
      
      HttpServletRequest  req = (HttpServletRequest)request;
      HttpServletResponse resp = (HttpServletResponse)response;
      HttpSession session = req.getSession(true);

      Object data = session.getAttribute( UIConstants.APP_DATA );
      Map appData = (data != null) ? (Map)data : null;
      if( appData != null && appData.containsKey( UIConstants.SECURITY_CONTEXT ) ) {
         chain.doFilter(request, response);
      }
      else {
         session.invalidate();
         resp.sendRedirect( getRedirectPage() );
      }
   }
   
   /**
    * @see javax.servlet.Filter#destroy()
    */
   public void destroy() {
      redirectPage = null;
   }
   
   /**
    * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
    */
   public void init( FilterConfig config ) throws ServletException {
      super.init( config );
      redirectPage = config.getInitParameter( UIConstants.REDIRECT_PAGE );
   }
   
   public String getRedirectPage() {
      return redirectPage;
   }
}