// Created Apr 27, 2005 4:49:40 PM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.trigger;

import gov.va.med.fw.service.ServiceException;

/**
 * Specifies the behavior for handling a TriggerAware instance.
 * 
 * @author DNS   BOHMEG
 */
public interface TriggerRouter {
	/** Must be implemented to determine how to handle a TriggerAware containing multiple TriggerEvent's.
	 * 		@return True if all TriggerEvent's were properly routed.  False if a repeat TriggerEvent was encountered.
	 *  */
	public boolean processTriggerAware(TriggerAware triggerAware) throws ServiceException;
	
	/** Must be implemented to determine how to handle a single TriggerEvent.
	 * 	@return True if the TriggerEvent was properly routed.  False if a repeat TriggerEvent was encountered.
	 * */
	public boolean processTriggerEvent(TriggerEvent triggerEvent) throws ServiceException;	
}
