package gov.va.med.fw.service.trigger;

import java.io.Serializable;
import java.util.Date;

public class TriggerEventMetrics implements Serializable {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2085353152618248995L;

	long createdTimestamp;

	long routedTimestamp;

	long consumedTimestamp;

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("TriggerEvent created at: " + new Date(createdTimestamp));
		if (routedTimestamp != 0 && createdTimestamp != 0)
			buf.append(", lag for created to routed (sec): "
					+ (routedTimestamp - createdTimestamp) / 1000.0);
		if (consumedTimestamp != 0 && routedTimestamp != 0)
			buf.append(", lag for routed to consumed (sec): "
					+ (consumedTimestamp - routedTimestamp) / 1000.0);

		return buf.toString();
	}

	public long getConsumedTimestamp() {
		return consumedTimestamp;
	}

	public void setConsumedTimestamp(long consumedTimestamp) {
		this.consumedTimestamp = consumedTimestamp;
	}

	public long getCreatedTimestamp() {
		return createdTimestamp;
	}

	public void setCreatedTimestamp(long createdTimestamp) {
		this.createdTimestamp = createdTimestamp;
	}

	public long getRoutedTimestamp() {
		return routedTimestamp;
	}

	public void setRoutedTimestamp(long routedTimestamp) {
		this.routedTimestamp = routedTimestamp;
	}
}
