/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.service.trigger;

import gov.va.med.fw.hl7.builder.JMSMetaData;
import gov.va.med.fw.hl7.builder.WrappedObjectBuilder;
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Initial javadoc for class TriggerEventBuilder.
 * TODO - Add content here
 * 
 * Created Feb 5, 2007 1:57:02 PM
 * @author DNS   BOHMEG
 */
public class TriggerEventBuilder extends AbstractBuilder {
	/**
	 * 
	 */
	private static final long serialVersionUID = -7272973375227716186L;

	public Object build(JMSMetaData meta) throws BuilderException {
		// get the TriggerEvent from Message
		TriggerEvent event = (TriggerEvent) WrappedObjectBuilder.getWrappedObject(meta.getJMSMessage());
		event.preConsumedInit();
		if(logger.isDebugEnabled()) {
			logger.debug("Unwrapping/consuming JMS payload TriggerEvent: " + event);
		}
		return event;
	}
}
