/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.service.trigger;

import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;
import gov.va.med.fw.hl7.builder.JMSMetaData;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.service.jms.SecureMessageWrapper;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Initial javadoc for class SecureTriggerEventBuilder.
 * TODO - Add content here
 * 
 * Created Aug 15, 2005 2:36:51 PM
 * @author DNS   BOHMEG
 */
public class SecureTriggerMsdsEventBuilder extends TriggerMsdsEventBuilder {
	private boolean shouldExtractTriggerEventPayload = false;
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2308447587731844524L;

	public Object build(JMSMetaData meta) throws BuilderException {		
		// get the TriggerEvent from Message
		VadirServiceResponseWrapper event = (VadirServiceResponseWrapper) super.build(meta);
		// build wrapper
		SecureMessageWrapper wrapper = new SecureMessageWrapper();
		wrapper.setPayload(event);		
		wrapper.setUserCredentials(getUserCredentials());
		return wrapper;
	}

	/**
	 * @param shouldExtractTriggerEventPayload The shouldExtractTriggerEventPayload to set.
	 */
	public void setShouldExtractTriggerEventPayload(
			boolean shouldExtractTriggerEventPayload) {
		this.shouldExtractTriggerEventPayload = shouldExtractTriggerEventPayload;
	}
	
	private UserCredentials getUserCredentials(){
		UserCredentials initiater = new UserCredentials();		
		initiater.setAnonymous(true);
		initiater.setLogicalID("MsdsService");		
		return initiater;
		
		
	}
	
}
