/*********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.pagination;

// Java Classes
import java.util.List;
import java.util.ArrayList;

// Framework classes
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.AbstractComponent;

/**
 * A paginated search service that does not perform a search, but rather returns previously retrieved
 * results.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class PreRetrievedResultsSearchService extends AbstractComponent implements PaginatedSearchService
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2608789063196181644L;

	public List search(SearchQueryInfo searchQueryInfo) throws ServiceException
    {
        // Get the optional results
        List results = searchQueryInfo.getResults();

        // Ensure we return an empty list rather than null if no results are present
        if (results == null)
        {
            results = new ArrayList();
        }

        // Set resultant information to the caller per the PaginatedSearchService contract
        searchQueryInfo.setTotalNumberOfEntries(results.size());
        searchQueryInfo.setSearchTypePerformed(SearchQueryInfo.SEARCH_READ_ALL);
        searchQueryInfo.setSortPerformed(false);
        searchQueryInfo.setSortColumnNotSupported(false);

        // Return the results
        return results;
    }
}
