/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.jms;

// Java classes
import java.util.Properties;

import gov.va.med.fw.service.ServiceException;

/**
 * Provides a generic interface to send data wrapped into a JMS Message object to a 
 * destination. A JMS Message contains data and properties and the specific JMS message
 * type is determined based on the type of an input data object.
 * 
 * Project: Framework
 * @author Venky Kullampalle
 * @version 1.0
 */
public interface TopicMessageProducer extends MessageProducer {

  public void publish( Object object, 
			Properties properties, 
			int deliverymode,
			int priority,
			long timeToLive ) throws ServiceException;
    
    public void publish( Object object, Properties properties ) throws ServiceException;
    
}