/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.jms;

// Java classes
import java.util.Properties;

import gov.va.med.fw.service.ServiceException;

/**
 * Provides a generic interface to send data wrapped into a JMS Message object to a 
 * destination. A JMS Message contains data and properties and the specific JMS message
 * type is determined based on the type of an input data object.
 * 
 * Project: Framework
 * @author DNS   LEV
 * @version 1.0
 */
public interface QueueMessageProducer extends MessageProducer {

    /** Sends a generic object and the specific set of string properties in a JMS Message. The
     * specific JMS Message type is determined based on a data object's class type.  If a class
     * type is either a HL7 Message or a string, a JMS TextMessage type is used.  If a class type
     * is a Map, a JMS MapMessage type is used.  If a class type is an array of bytes, a JMS
     * BytesMessage type is used.  Otherwise, an ObjectMessage is used to wrap a message data.
     *  
     * @param data An object to send to a message queue
     * @param properties A properties to send with a message
     * @param deliveryMode A delivery mode to send a message whether it is persistent or not
     * @param priority A property to send a message
     * @param timeToLive A total time for a message to live in a queue
     * @throws ServiceException Thrown if failed to send a message
     */
    public void send( Object object, 
            						Properties properties, 
            						int deliverymode,
            						int priority,
            						long timeToLive ) throws ServiceException;
    
    /** Sends a generic object and the specific set of string properties in a JMS Message. The
     * specific JMS Message type is determined based on a data object's class type.  If a class
     * type is either a HL7 Message or a string, a JMS TextMessage type is used.  If a class type
     * is a Map, a JMS MapMessage type is used.  If a class type is an array of bytes, a JMS
     * BytesMessage type is used.  Otherwise, an ObjectMessage is used to wrap a message data.
     *  
     * @param data An object to send to a message queue
     * @param properties A properties to send with a message
     * @throws ServiceException Thrown if failed to send a message
     */
    public void send( Object object, Properties properties ) throws ServiceException;
    
   }