/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.jms;

// Java classes
import java.io.Serializable;

import javax.jms.Session;

/**
 * Provides a generic interface to send data wrapped into a JMS Message object to a 
 * destination. A JMS Message contains data and properties and the specific JMS message
 * type is determined based on the type of an input data object.
 * 
 * Project: Framework
 * @author DNS   LEV
 * @version 1.0
 */
public interface MessageProducer extends Serializable {
   /** Closes a session that is used to send a message
     * @param session A session used to send a message
     */
    public void close( Session session );
}