/********************************************************************
Copyright  2004 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.service.jms;

// Framework classes
import gov.va.med.fw.service.ServiceException;

/** A base exception for all service requests.  This exception is thrown if a 
 * request is not fulfilled successfully.
 *
 * @author  Vu Le
 * @version 1.0
 */
public class JMSServiceException extends ServiceException {
	
   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -838511740911173138L;

	/**
    * Creates new <code>ServiceException</code> without detail message.
    */
    public JMSServiceException() {
      super();
   }
   
   /**
    * Constructs an <code>ServiceException</code> with the specified detail message.
    * @param msg the detail message.
    */
    public JMSServiceException(String msg) {
      super(msg);
   }
   
   /**
    * Constructs an <code>ServiceException</code> with the specified detail message
    * and a caused exception
    * @param msg the detail message.
    * @param cause the caused exception
    */
    public JMSServiceException(String msg, Throwable cause) {
      super( msg, cause );
   }
}


