/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.config;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Extension of java.util.Properties that is more Spring friendly and allows for easy use
 * of inheritance in Properties definitions.
 * 
 * Created Nov 30, 2006 1:09:47 PM
 * 
 * @author DNS   BOHMEG
 */
public class Properties extends java.util.Properties {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8816740422916837445L;

	public Properties() {
		this(null);
	}

	/**
	 * Creates an empty property list with the specified defaults.
	 * 
	 * @param defaults
	 *            the defaults.
	 */
	public Properties(java.util.Properties defaults) {
		super(defaults);
	}
	
	public void setInheritedProperties(java.util.Properties inheritedData) {
		doSetProperties(inheritedData, false);
	}
	
	
	public void setProperties(java.util.Properties data) {
		doSetProperties(data, true);
	}
	
	public void doSetProperties(java.util.Properties data, boolean overrideExistingKey) {
		if (data != null) {
			Set elements = data.entrySet();
			Iterator itr = elements != null ? elements.iterator() : null;
			Map.Entry element = null;
			boolean containsKey = false;
			if (itr != null) {
				while (itr.hasNext()) {
					element = (Map.Entry) itr.next();
					containsKey = this.containsKey(element.getKey());
					
					if(!containsKey || (containsKey && overrideExistingKey)) {
						setProperty(element.getKey().toString(), element.getValue()
								.toString());
					}
				}
			}
		}		
	}
}
