/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.config;

import gov.va.med.fw.service.AbstractComponent;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

/**
 * @author DNS   LEV
 *
 */
public abstract class AbstractBeanPostProcessor extends AbstractComponent implements BeanPostProcessor {

	/**
	 * A default constructor
	 */
	protected AbstractBeanPostProcessor() {
		super();
	}
	
	/**
	 * @see org.springframework.beans.factory.config.BeanPostProcessor#postProcessBeforeInitialization(java.lang.Object, java.lang.String)
	 */
	public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
		return bean;
	}

	/**
	 * @see org.springframework.beans.factory.config.BeanPostProcessor#postProcessAfterInitialization(java.lang.Object, java.lang.String)
	 */
	public Object postProcessAfterInitialization(Object bean, String beanName)	throws BeansException {
		return bean;
	}
}