// Package 
package gov.va.med.fw.service;

/**
 * A service exception that indicates that a passed in entity to be updated hasn't changed at all from the on-file
 * version of that entity (i.e. both entities "match").
 *
 * @author Andrew Pach
 */
public class EntityNotChangedException extends ServiceException
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -4279568812333822503L;

   /**
     * Default constructor.  A default message will be used.
     */
    public EntityNotChangedException()
    {
        super();
    }

    /**
     * Constructs a <code>EntityNotChangedException</code> with the specified detail message.
     *
     * @param msg the detail message.
     */
    public EntityNotChangedException(String msg)
    {
        super(msg);
    }

    /**
     * Constructs a <code>EntityNotChangedException</code> with the specified detail message and a caused exception.
     *
     * @param msg the detail message.
     * @param cause the caused exception
     */
    public EntityNotChangedException(String msg, Throwable cause)
    {
        super(msg, cause);
    }
}
