/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.io.Serializable;
import java.util.Set;

/**
 * UserPrincipal, extends from Principal, provides user profile and 
 * account related information.
 * UserPrincipal also contains a Collection of RolePrincipal Object, that 
 * specifies what roles user have.
 * 
 * @see gov.va.med.fw.security.RolePrincipal
 * 
 * @author Martin Francisco
 * @author Ghazenfer Mansoor
 * @version 1.0
 */
public interface UserPrincipal
    extends Principal, Serializable {
    
    /**
     * First name of the user
     * @return String - given name of a user
     */
    public String getGivenName();

    /**
     * Middle name of the user
     * @return String - middle name of a user
     */
    public String getMiddleName();

    /**
     * Family name of the user
     * @return String - family name of a user
     */
    public String getFamilyName();

    /**
     * @return String - password of the user 
     */
    public String getPassword();

    
    /**
     * Check whether is user the anonymous user or not.
     * @return true if anonymous, false otherwise.
     */
    public boolean isAnonymous();

    /**
     * A Set of RolePrincipal's this user belong to.
     * If this user does not have any role, this method returns empty Set.
     * @return Set of RolePrincipal, never null.
     */
    public Set getUserRoles();
    
    /**
     * Get generic Authority object that implements GrantedAuthority Interface
     * @return
     */
    public Set getAuthorities ();
    
    /** Get the user credentials information for this Principal
     * 
     * @return UserCredentials
     */
    public UserCredentials getUserCredentials();
    
    public boolean isPermissionGranted(String permission);
}