/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;


/**
 * LoginManager is the centralized point to perform the authentication and
 * clean up at the end. UI use this through LogonAction to perform login and
 * SignoutAction to perform logout at the end. If the HttpServletRequest is specified, 
 * it will set the request details such as session id, remote ip address in a authentication
 * token. To do login and logout from the UI application, use the methods that
 * has HttpServletRequest paramter, do add/remove attributes required by the
 * Acegi Security.
 * 
 * @author DNS   MANSOG
 * @date May 6, 2005
 */
public interface LoginManager {
    /**
     * Perform the login given the HttpServletRequest, username and password.
     * 
     * @param request
     * @param userCredentail
     * @throws IllegalArgumentException if username or password is null.
     * @throws LoginException if authentication fails.
     */
    public void login(HttpServletRequest request,UserCredentials userCredentail) 
    throws LoginException;

    /**
     * Login using username and password.
     * This call is same as calling login(null, username, password).
     * 
     * @param userCredentail - user credentails
     * @throws IllegalArgumentException if username or password is null.
     * @throws LoginException if authentication fails.
     */
    public void login(UserCredentials userCredentail)
            throws LoginException;

    /**
     * Anonymously login the user. Throws
     * <code>java.lang.IllegalStateException</code> if anonymous login is not
     * enabled/allowed.
     * 
     * @throws IllegalStateException if anonymous login is not allowed.
     */
    public void loginAnonymous();

    /**
     * Anonymously login the user. Throws
     * <code>java.lang.IllegalStateException</code> if anonymous login is not
     * enabled/allowed.
     * 
     * 	@param logicalID Logical id to use for this anonymous user
     * @throws IllegalStateException if anonymous login is not allowed.
     */
    public void loginAnonymous(String logicalID);
    
    /**
     * Logout user by removing the Authentication information from Context.
     */
    public void logout();

    /**
     * Logout user by remove the Authentication information from Context as well
     * as remove the Acegi specific key from the Session.
     * 
     * @param request
     */
    public void logout(HttpServletRequest request);
}