/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import gov.va.med.fw.service.ServiceException;

public interface LDAPService {
    /**
     * Autheticates by connecting to LDAP (Active directory)
     * @param userName
     * @param password
     * @return
     * @throws ServiceException
     */
    public UserPrincipal authenticate(String userName, String password) 
        throws ServiceException;
    /**
     * Retrieves the User attributes from ldap server using the default domain name
     * @param userName
     * @return
     * @throws ServiceException
     */
    public UserPrincipal getUserInfo(String userName)
        throws ServiceException;    
   /**
     * Retrieves the User attributes from ldap server and throws an exception if multiple
     * users match the search criterai (firstname and lastname are required fields
     * @param userName
     * @return
     * @throws ServiceException
     */    
    public UserPrincipal getUserInfo(String firstName, String lastName, String middleName)
        throws ServiceException;
}
