/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import org.acegisecurity.Authentication;

/**
 * <code>net.sf.acegisecurity.Authentication</code> Object to provide
 * additional methods required by framework.
 * 
 * @see <code>net.sf.acegisecurity.Authentication</code>
 * 
 * @author DNS   MANSOG
 * @date May 3, 2005 11:03:09 AM
 */
public interface AuthenticationObject extends Authentication {
    /**
     * Flag to indicate whether a user is logged in or not.
     * 
     * @return true if logged in, false otherwise.
     */
    public boolean isLoggedIn();

    /**
     * UserPrincipal Object that must exist for each logged in user. If
     * isLoggedIn() return false, this method may return null. If isLoggedIn()
     * return true, this method should not return null.
     * 
     * @return UserPrincipal or null if no user principal is set till now.
     */
    public UserPrincipal getUserPrincipal();
}