/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.ProviderManager;

/**
 * AuthenticationManager implementation, extends from Acegi's implementation
 * ProviderManager. Override doAuthentication to add custom behaviour required.
 * 
 * @see <code>net.sf.acegisecurity.providers.ProviderManager</code>
 * 
 * @author DNS   MANSOG
 * @date May 2, 2005 6:04:41 PM
 */
public class AuthenticationManagerImpl extends ProviderManager {

    /*
     * Checks for loggedIn flag before delegating the authentication request to
     * the super class. If the user is already logged in, it returns the same
     * Authentication Object.
     * 
     * @see net.sf.acegisecurity.AbstractAuthenticationManager#doAuthentication(net.sf.acegisecurity.Authentication)
     */
    public Authentication doAuthentication(Authentication auth)
            throws AuthenticationException {
        if (auth != null && auth instanceof AuthenticationObject) {
            AuthenticationObject authToken = (AuthenticationObject) auth;
            if (authToken.isLoggedIn()) {
                return auth;
            }
        }
        return super.doAuthentication(auth);
    }
}