/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.scheduling;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

/**
 * @author DNS   LEV
 *
 */
public class UndiscoverableStatelessScheduledService extends StatelessScheduledService {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4703538488711775908L;

	/**
	 * An instance of factorySelector
	 */
	private String factorySelector = null;
	
	/**
	 * An instance of contextKey
	 */
	private String contextKey = null;
	
	/**
	 * A default constructor
	 */
	public UndiscoverableStatelessScheduledService() {
		super();
	}

	/**
	 * @see gov.va.med.fw.scheduling.StatelessScheduledService#getApplicationContext()
	 */
	public ApplicationContext getApplicationContext() {
		
		ApplicationContext ctx = super.getApplicationContext();
		if( this.contextKey != null && this.factorySelector != null ) {
			BeanFactoryLocator bfl = ContextSingletonBeanFactoryLocator.getInstance( getFactorySelector() );
			BeanFactoryReference bfr = bfl.useBeanFactory( getContextKey() );
			BeanFactory bf = bfr.getFactory();
			ctx = bf instanceof ApplicationContext ? (ApplicationContext)bf : null;
		}
		return ctx;
	}


	/**
	 * @return Returns the contextKey.
	 */
	public String getContextKey() {
		return contextKey;
	}

	/**
	 * @param contextKey The contextKey to set.
	 */
	public void setContextKey(String contextKey) {
		this.contextKey = contextKey;
	}

	/**
	 * @return Returns the factorySelector.
	 */
	public String getFactorySelector() {
		return factorySelector;
	}

	/**
	 * @param factorySelector The factorySelector to set.
	 */
	public void setFactorySelector(String factorySelector) {
		this.factorySelector = factorySelector;
	}
}
