/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.scheduling;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

/**
 * Contains status information about a Trigger that could be used for
 * instrumentation needs.
 * 
 * Created Jun 26, 2006 2:21:42 PM
 * @author DNS   BOHMEG
 */
public class TriggerStatus extends AbstractEntity {
	/**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 9003524138022133858L;
   public static String NORMAL_STATUS = "WAITING";
	public static String PAUSED_STATUS = "PAUSED";
	
	private Date nextFireTime;
	private String status;
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("nextFireTime", nextFireTime);
		builder.append("status", status);
	}

	/**
	 * @return Returns the nextFireTime.
	 */
	public Date getNextFireTime() {
		return nextFireTime;
	}

	/**
	 * @param nextFireTime The nextFireTime to set.
	 */
	public void setNextFireTime(Date nextFireTime) {
		this.nextFireTime = nextFireTime;
	}

	/**
	 * @return Returns the status.
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status The status to set.
	 */
	public void setStatus(String status) {
		this.status = status;
	}
	
	public boolean isActive() {
		return NORMAL_STATUS.equals(status);
	}
}
