/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/

// Package
package gov.va.med.fw.rule;

import gov.va.med.fw.model.lookup.SeverityType;

// java classes

/**
 * A base exception for all bueinss rule invocation errors. This exception is
 * thrown if a service failed to execute a business rule because of either a
 * user exception thrown in a rule or invalid input parameters for a rule flow
 * and a rule wrapper class
 * 
 * @author Vu Le
 * @version 1.0
 */
public class RuleValidationException extends RuleException {
	private SeverityType severityType = SeverityType.ERROR;
	
	// CCR10399 -- added attribute to allow the option of not generating worklist
	// when a consistency check fails
	private boolean createWkList = true;

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8793640437493431013L;

	/**
	 * Creates new <code>RuleException</code> without detail message.
	 */
	public RuleValidationException() {
		super();
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message.
	 * 
	 * @param msg
	 *            the detail message.
	 */
	public RuleValidationException(String msg) {
		super(msg);
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message and a caused exception
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 */
	public RuleValidationException(String msg, Throwable cause) {
		super(msg, cause);
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message, a caused exception, a rule flow name, and a rule wrapper
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param ruleFlow
	 *            a rule flow name
	 * @param wrappter
	 *            a rule wrapper
	 */
	public RuleValidationException(String msg, Throwable cause,
			String ruleFlow, RuleParameter wrapper) {
		super(msg, cause, ruleFlow, new RuleParameter[] { wrapper });
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message, a caused exception, a rule flow name, and a rule wrapper
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param ruleFlow
	 *            a rule flow name
	 * @param wrappter
	 *            a rule wrapper
	 */
	public RuleValidationException(String msgID, Object originator,
			String ruleFlow, RuleParameter wrapper) {
		super(msgID, originator, ruleFlow, wrapper);
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message, a caused exception, a rule flow name, and a list of rule
	 * wrappers
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param ruleFlow
	 *            a rule flow name
	 * @param wrappter
	 *            a rule wrapper
	 */
	public RuleValidationException(String msg, Throwable cause,
			String ruleFlow, RuleParameter[] wrappers) {
		super(msg, cause, ruleFlow, wrappers);
	}

	/**
	 * @return Returns the severityType.
	 */
	public SeverityType getSeverityType() {
		return severityType;
	}

	/**
	 * @param severityType
	 *            The severityType to set.
	 */
	public void setSeverityType(SeverityType severityType) {
		this.severityType = severityType;
	}

	/**
	 * 
	 * @return createWkList
	 */
	public boolean isCreateWkList() {
		return createWkList;
	}

	/**
	 * 
	 * @param createWkList
	 */
	public void setCreateWkList(boolean createWkList) {
		this.createWkList = createWkList;
	}
}