/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.rule;

//Java classes

// Framework classes

/**
 * A generic marker interface that represents a rule input. A rule input
 * represents an object that contains information needed for executing
 * a rule.
 * 
 * @author DNS   LEV
 * @version 1.0
 */
public interface RuleParameter extends RuleFlowNameAware, RuleMethod, RuleSession, RuleDataAware, RuleParameterNameAware {
   
   /**
    * @return Returns the ruleData.
    */
   public RuleDataAware getRuleDataAware();

   /**
    * @param ruleData The ruleData to set.
    */
   public void setRuleDataAware(RuleDataAware ruleData);

   /**
    * @return Returns the ruleMethod.
    */
   public RuleMethod getRuleMethod();

   /**
    * @param ruleMethod The ruleMethod to set.
    */
   public void setRuleMethod(RuleMethod ruleMethod);

   /**
    * @return Returns the ruleParameterName.
    */
   public RuleParameterNameAware getRuleParameterNameAware();

   /**
    * @param ruleParameterName The ruleParameterName to set.
    */
   public void setRuleParameterNameAware( RuleParameterNameAware ruleParameterName );

   /**
    * @return Returns the ruleSession.
    */
   public RuleSession getRuleSession();

   /**
    * @param ruleSession The ruleSession to set.
    */
   public void setRuleSession(RuleSession ruleSession);

   /**
    * @return Returns the ruleFlowNameAware.
    */
   public RuleFlowNameAware getRuleFlowNameAware();

   /**
    * @param ruleFlowNameAware The ruleFlowNameAware to set.
    */
   public void setRuleFlowNameAware(RuleFlowNameAware ruleFlowNameAware);
}