package gov.va.med.fw.rule;

import java.util.Map;

public interface RuleFlow {

   /** Executes a set of rule parameters 
    * @param data
    * @return
    * @throws RuleException
    */
   public abstract Object execute(RuleParameters params, RuleDataAware ruleData)
         throws RuleException;

   /** Executes a set of rule parameters already populated with a collection </br>
    * of rule data keyed by a parameter name in a hash map. 
    * @param params A collection of rule parameters
    * @return Object A result object returned from invoking a rule flow
    * @throws RuleException In case of errors
    */
   public abstract Object execute(RuleParameters params, Map ruleData)
         throws RuleException;

   /** Executes a rule parameter 
    * @param data
    * @return
    * @throws RuleException
    */
   public abstract Object execute(RuleParameter param, RuleDataAware data)
         throws RuleException;

}