/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.rule;

import gov.va.med.fw.service.event.ServiceEvent;

/** An event encapsulating a rule wrapper class. This rule event
 * is listenned in a RuleService class.  When a rule event is triggered
 * a rule service is invoked to execute a specific rule flow.
 *  
 * @author Vu Le
 * @version 1.0
 */
public class RuleEvent extends ServiceEvent {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6699798137882786206L;

	/**
    * A rule set name 
    */
   private String ruleflow = null;
   
   /**
    * A input object to insert to a rule for execution
    */
   private RuleParameter ruleParam = null;
   
   /**
    * A input object to insert to a rule for execution
    */
   private RuleParameters ruleParams = null;

   /** An event triggered by the specific source
    * @param source A source of an event
    */
   public RuleEvent( Object source ) {
      super( source );
   }

   /** An event triggered by the specific source
    * containing a rule parameter
    * @param source A source of an event
    * @param param A rule parameter
    * @param ruleFlow A rule flow name
    */
   public RuleEvent( Object source, RuleParameter param, String ruleFlow ) {
      super( source );
      this.ruleParam = param;
      this.ruleflow = ruleFlow;
   }

   /** An event triggered by the specific source
    * containing specific rule parameters
    * @param source A source of an event
    * @param params A rule parameters
    * @param ruleFlow A rule flow name
    */
   public RuleEvent( Object source, RuleParameters params, String ruleFlow ) {
      super( source );
      this.ruleParams = params;
      this.ruleflow = ruleFlow;
   }

   /**
    * @return Returns the ruleInput.
    */
   public RuleParameter getRuleParameter() {
      return ruleParam;
   }
   
   /** Returns rule parameters
    * @return Returns the rule parameters
    */
   public RuleParameters getRuleParameters() {
      return ruleParams;
   }
   
   /** Returns a rule flow name
    * @return Returns the rule flow name.
    */
   public String getRuleflow() {
      return ruleflow;
   }
}