/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.fw.rule;

// Java classes
import java.io.Serializable;

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractEntity;

// EDB classes

/**
 * Project: Framework
 * 
 * @author DNS   LEV
 * @version 1.0
 */
public interface RuleDataAware extends Serializable {

   /**
    * Returns a printine entity stored in an input data collection
    * 
    * @return A printine version of an entity
    */
   public AbstractEntity getPristineData();

   /**
    * Sets a pristine entity stored in an input data collection
    * 
    * @param pristine A pristine version of an entity
    */
   public void setPristineData(AbstractEntity pristine);

   /**
    * Returns an incoming entity stored in an input data collection
    * 
    * @return An incoming version of an entity
    */
   public AbstractEntity getIncomingData();

   /**
    * Sets an incoming entity stored in an input data collection
    * 
    * @param incoming An incoming version of an entity
    */
   public void setIncomingData(AbstractEntity incoming);

   /**
    * Returns a result entity stored in an input data collection
    * 
    * @return A result version of an entity
    */
   public AbstractEntity getResultData();

   /**
    * Sets a result entity stored in an input data collection
    * 
    * @param result A result version of an entity
    */
   public void setResultData(AbstractEntity result);
}