/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.jasperreport.data;

// Java classes

// Library classes

// Framework classes
import java.util.Map;

import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.data.AbstractReportDataService;
import gov.va.med.fw.report.data.ReportDataDAO;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.ReportDataIterator;

// ESR classes

/**
 * Implements <code>ReportDataService</code> interface to provide
 * report data using a report data iterator to iterate through a 
 * report data's result set returned from a report data DAO.  A concrete
 * <code>JRDataSource</code> is instantiated to encapsulates a report data
 *
 * Project: Framework</br>
 * Created on: 1:06:08 PM </br>
 *
 * @author DNS   LEV
 */
public class JasperReportDataService extends AbstractReportDataService {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3229794258187177377L;

	/**
	 * An instance of metaDataMap
	 */
	private Map metaDataMap = null;
	
	/**
	 * A default constructor
	 */
	public JasperReportDataService() {
		super();
	}

	/**
	 * @param metaDataMap The metaDataMap to set.
	 */
	public void setMetaDataMap(Map metaDataMap) {
		this.metaDataMap = metaDataMap;
	}
	
	/**
	 * @param metaDataMap The metaDataMap to set.
	 */
	protected Map getMetaData( String reportName ) {
		
		Map map = null;
		if( this.metaDataMap != null && this.metaDataMap.containsKey( reportName ) ) {
			Object data = this.metaDataMap.get( reportName );
			map = data instanceof Map ? (Map)data : null;
		}
		return map;
	}
	
	/**
	 * @see gov.va.med.fw.report.data.AbstractReportDataService#doRequestData(gov.va.med.fw.report.ReportConfiguration)
	 */
	protected ReportData doRequestData( ReportConfiguration configuration ) throws ReportException {
		
		// Create an iterator to iterate through a result data collection
		ReportDataDAO dao = this.getReportDataDAO( configuration );
		ReportDataIterator iterator = getReportDataIterator( dao, configuration );
		
		// Create a custom Jasper Report data source that leverages an iterator to pull
		// into memory only a block of data at a time
		String reportName = this.getNameResolver().getReportName( configuration );
		JasperReportDataSource reportDataSource = 
			new JasperReportDataSource( iterator, getMetaData( reportName ), configuration );
		
		// Creates a wrapper to return
		JasperReportData data = new JasperReportData( reportDataSource );
		return data;
	}
    
    protected ReportDataIterator getReportDataIterator(ReportDataDAO dao, ReportConfiguration configuration) {
        return new ReportDataIterator( dao, configuration );
    }
}