/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.jasperreport;

// Java classes
// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;

import java.io.ByteArrayOutputStream;
// Library classes

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;

/**
 * 
 *
 * Project: Framework</br>
 * Created on: 3:09:40 PM </br>
 *
 * @author DNS   LEV
 */
public class PDFExporter extends AbstractJasperReportExporter {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8011068634784421629L;

	/**
	 * A default constructor
	 */
	public PDFExporter() {
		super();
	}

	protected ByteArrayOutputStream exportJasperReport(ReportConfiguration reportConfig, JasperPrint print ) throws ReportException {

		try {
			ByteArrayOutputStream output = new ByteArrayOutputStream();
			
			JRPdfExporter exporter = new JRPdfExporter();
			exporter.setExporterInput(new SimpleExporterInput(print));
			exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(output));
			
			SimplePdfExporterConfiguration config = new SimplePdfExporterConfiguration();
			config.setTagLanguage("EN-US");
			config.setTagged(true); 
			if(reportConfig != null) {
				config.setMetadataTitle(reportConfig.getReportTitle());
			} else {
				config.setMetadataTitle(ReportConfiguration.DEFAULT_REPORT_TITLE);
			}
			exporter.setConfiguration(config);
			
			exporter.exportReport();
			
			return output;
		}
		catch( JRException e ) {
			throw new ReportException( "Failed to export a report", e );
		}
	}
}