/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.jasperreport;

// Java classes
// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;

import java.io.ByteArrayOutputStream;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
// Library classes

/**
 * 
 *
 * Project: Framework</br>
 * Created on: 3:09:40 PM </br>
 *
 * @author DNS   LEV
 */
public class HTMLExporter extends AbstractJasperReportExporter {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8011068634784421629L;

	/**
	 * A default constructor
	 */
	public HTMLExporter() {
		super();
	}

	protected ByteArrayOutputStream exportJasperReport( ReportConfiguration reportConfig, JasperPrint print ) throws ReportException {
		try {
			ByteArrayOutputStream output = new ByteArrayOutputStream();
			
			HtmlExporter exporter = new HtmlExporter();
			exporter.setExporterInput(new SimpleExporterInput(print));
			exporter.setExporterOutput(new SimpleHtmlExporterOutput(output));
			
			SimpleHtmlExporterConfiguration config = new SimpleHtmlExporterConfiguration();
			exporter.setConfiguration(config);
			
			exporter.exportReport();
			
			return output;
		}
		catch( JRException e ) {
			throw new ReportException( "Failed to export a report", e );
		}
		
	}
}