/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.jasperreport;

// Java classes
import gov.va.med.fw.report.ReportConfiguration;
// Framework classes
import gov.va.med.fw.report.ReportException;

import java.io.ByteArrayOutputStream;

import net.sf.jasperreports.engine.JRException;
// Library classes
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;

// ESR classes

/**
 * 
 *
 * Project: Framework</br>
 * Created on: 3:09:40 PM </br>
 *
 * @author DNS   LEV
 */
public class ExcelExporter extends AbstractJasperReportExporter {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8011068634784421629L;

	/**
	 * A default constructor
	 */
	public ExcelExporter() {
		super();
	}

	protected ByteArrayOutputStream exportJasperReport( ReportConfiguration reportConfig, JasperPrint print ) throws ReportException {
		try {
			ByteArrayOutputStream output = new ByteArrayOutputStream();
			
			JRXlsExporter exporter = new JRXlsExporter();
			exporter.setExporterInput(new SimpleExporterInput(print));
			exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(output));
			
			SimpleXlsReportConfiguration config = new SimpleXlsReportConfiguration();
			config.setOnePagePerSheet(true);
			exporter.setConfiguration(config);
			
			exporter.exportReport();
			
			return output;
		}
		catch( JRException e ) {
			throw new ReportException( "Failed to export a reporter", e );
		}
	}
}
