/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.jasperreport;

// Java classes
import gov.va.med.fw.report.ReportConfiguration;
// Framework classes
import gov.va.med.fw.report.ReportException;

import java.io.ByteArrayOutputStream;

import net.sf.jasperreports.engine.JRException;
// Library classes
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;

// ESR classes

/**
 * 
 *
 * Project: Framework</br>
 * Created on: 3:09:40 PM </br>
 *
 * @author DNS   LEV
 */
public class CSVExporter extends AbstractJasperReportExporter {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8011068634784421629L;

	/**ByteArrayOutputStream
	 * A default constructor
	 */
	public CSVExporter() {
		super();
	}

	protected ByteArrayOutputStream exportJasperReport( ReportConfiguration reportConfig, JasperPrint print ) throws ReportException {
		
		try {
			ByteArrayOutputStream output = new ByteArrayOutputStream();
			
			JRCsvExporter exporter = new JRCsvExporter();
			exporter.setExporterInput(new SimpleExporterInput(print));
			exporter.setExporterOutput(new SimpleWriterExporterOutput(output));
			
			SimpleCsvExporterConfiguration config = new SimpleCsvExporterConfiguration();
			exporter.setConfiguration(config);
			
			exporter.exportReport();
			
			return output;
		}
		catch( JRException e ) {
			throw new ReportException( "Failed to export a report", e );
		}
	}
}