/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report;

// Java classes
import java.io.Serializable;

// Library classes

// Framework classes
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.report.data.ReportData;

// ESR classes

/**
 * A generic service to generate a report.  
 *
 * Project: Framework</br>
 * Created on: 9:39:43 AM </br>
 *
 * @author DNS   LEV
 */
public interface ReportService extends Serializable {
	
	/** Generates a report using the specific report configuration.
	 * Use this method to generate a report that already has a well
	 * statically defined report criteria set, and report template.
	 * A report criteria set is used to query report data to populate
	 * a report template. 
	 * 
	 * @param configuration A report configuration
	 * @return Report that encapsulates the actual formatted report
	 */
	public void generateReport( ReportConfiguration configuration ) throws ServiceException;
	
	/** Generates a report using the specific report configuration and data
	 * 
	 * @param configuration A report configuration 
	 * @param data Data to generate a report
	 * @return Report that encapsulates the actual formatted report
	 */
	public void generateReport( ReportConfiguration configuration, ReportData data ) throws ServiceException;
}